function out = fct_paper_figures_tables_RP(output_files_write)

    % LOAD 
    load estimates_RP.mat          % main estimates
    load standard_errors_RP.mat    % standard errors
    raw = load('IG_raw_0_105_RP.txt'); % raw data    
    observables = csvread('IG_raw_0_105_RP_with_observables.csv',1,0); 


    FINALEST.GPLUS      = GPLUS;
    FINALEST.GBAR       = GBAR;
    FINALEST.GBARW      = GBARW;
    FINALEST.GUSHORT    = GUSHORT;
    FINALEST.GUSHORTW   = GUSHORTW;
    FINALEST.GBARP2     = GBARP2;
    FINALEST.GBARP2W    = GBARP2W;
    FINALEST.GUSHORTP2  = GUSHORTP2;
    FINALEST.GUSHORTP2W = GUSHORTP2W;
    FINALEST.GPLUSdecomp = GPLUSdecomp;
    
    FINALEST.GBARdecomp     = GBARdecomp;
    FINALEST.GBARWdecomp    = GBARWdecomp;
    FINALEST.GUSHORTdecomp  = GUSHORTdecomp;
    FINALEST.GUSHORTWdecomp = GUSHORTWdecomp;
    FINALEST.GBARP2decomp   = GBARP2decomp;
    FINALEST.GBARP2Wdecomp    = GBARP2Wdecomp;
    FINALEST.GUSHORTP2decomp  = GUSHORTP2decomp;
    FINALEST.GUSHORTP2Wdecomp = GUSHORTP2Wdecomp;
    
    FINALEST.paramdata = paramdata;
    FINALEST.EMinput   = EMinput;
    FINALEST.EMoutput  = EMoutput;
    FINALEST.MDinput   = MDinput;
    FINALEST.MDoutput  = MDoutput;
    
    Gnames = {'GBAR', 'GUSHORT', 'GBARW', 'GUSHORTW',...
    'GBARP2', 'GUSHORTP2', 'GBARP2W', 'GUSHORTP2W'};
    
    % set this to 1 if you want to overwrite output files
    

%==========================================================================
% IG hazards
    alp1_ex = 0.1; bet1_ex = [4, 10,30];
    sig1_ex = 1./bet1_ex; mu1_ex = alp1_ex.*sig1_ex;
    
    alp2_ex = [0.1, 0.18829943031118113,  0.2675301543775812]; 
    bet2_ex = [10, 9.5,9.2];
    sig2_ex = 1./bet2_ex; mu2_ex = alp2_ex.*sig2_ex;
    
    ttgrid = [0:1:400];
    for i = 1:3
        HRex1(:,i) =  fct_hazard(ttgrid,mu1_ex(i),sig1_ex(i));    
        HRex2(:,i) =  fct_hazard(ttgrid,mu2_ex(i),sig2_ex(i));    
    end
    
    figure(1)
    subplot(1,2,1)
    plot(ttgrid,HRex1)
    xlabel('duration in weeks')
    ylabel('hazard')
    subplot(1,2,2)
    plot(ttgrid,HRex2)
    xlabel('duration in weeks')
    ylabel('hazard')
    sgtitle('Figure 1:  Hazards implied by the inverse Gaussian distribution')

    if output_files_write ==1
        duration = ttgrid';
        H1 = round(HRex1(:,1),5);
        H2 = round(HRex1(:,2),5);
        H3 = round(HRex1(:,3),5);
        H4 = round(HRex2(:,1),5);
        H5 = round(HRex2(:,2),5);
        H6 = round(HRex2(:,3),5);

        tab = table(duration,H1,H2,H3,H4,H5,H6);
        writetable(tab,'hazard_RP.txt','Delimiter',' ');
        
        tab = table(duration,H4,H5,H6);
        writetable(tab,'hazard2_RP.txt','Delimiter',' ')
    end

%==========================================================================
% CORRELATION BETWEEN THE FIRST AND SECOND SPELL
    sel1 = paramdata.data(:,1)<=paramdata.T ;
    sel2 = paramdata.data(:,2)<=paramdata.T ;
    t1t2 = paramdata.data(sel1.*sel2==1,:);
    
    NN = sum(t1t2(:,3));
    Et1 = t1t2(:,1)'*t1t2(:,3)/NN;
    Et2 = t1t2(:,2)'*t1t2(:,3)/NN;
    Vt1 = (t1t2(:,1)'-Et1).^2*t1t2(:,3)/NN;
    Vt2 = (t1t2(:,2)'-Et2).^2*t1t2(:,3)/NN;
    Et1t2 = (t1t2(:,1).*t1t2(:,2))'*t1t2(:,3)/NN;
    CORt1t2 = (Et1t2-Et1*Et2)/sqrt(Vt1*Vt2);
    
    fprintf('Analysis of completed spells \n')
    fprintf('Average duration of the first and second spell: %5.1f and %5.1f \n',Et1,Et2)
    fprintf('Correlation between the first two spells is %5.2f \n',CORt1t2)
    
    
    t1t2_sym = paramdata.data_sym;
    NN = sum(t1t2_sym(:,3));
    Et1_sym = t1t2_sym(:,1)'*t1t2_sym(:,3)/NN;
    Et2_sym = t1t2_sym(:,2)'*t1t2_sym(:,3)/NN;
    Vt1_sym = (t1t2_sym(:,1)'-Et1_sym).^2*t1t2_sym(:,3)/NN;
    Vt2_sym = (t1t2_sym(:,2)'-Et2_sym).^2*t1t2_sym(:,3)/NN;
    Et1t2_sym = (t1t2_sym(:,1).*t1t2_sym(:,2))'*t1t2_sym(:,3)/NN;
    CORt1t2_sym = (Et1t2_sym-Et1_sym*Et2_sym)/sqrt(Vt1_sym*Vt2_sym);
    
    fprintf('Analysis of completed spells with symmetric data\n')
    fprintf('Average duration of the first and second spell: %5.1f and %5.1f \n',Et1_sym,Et2_sym)
    fprintf('Correlation between the first two spells is %5.2f \n',CORt1t2_sym)


%==========================================================================
% MARGINAL DISTRIBUTION OF SPELLS: DATA AND MODEL
% data
    k = 0;
    for t = 0:104
        k = k+1;
        sel1 = (paramdata.data(:,1)==t) & (paramdata.data(:,2)<105);
        sel2 = (paramdata.data(:,2)==t) & (paramdata.data(:,1)<105);
        marg_distr_data(k,1) = t;
        marg_distr_data(k,2) = sum(paramdata.data(sel1,3))+sum(paramdata.data(sel2,3));
        
        sel3 = (paramdata.data(:,1)==t);    
        separate_t(k,1) = sum(paramdata.data(sel3,3));
        
        % first and second spell
        marg_distr_data_spell(k,1) = t;
        
        sel4 = (paramdata.data_orig(:,1)==t) & (paramdata.data_orig(:,2)<105);
        sel5 = (paramdata.data_orig(:,2)==t) & (paramdata.data_orig(:,1)<105);
        marg_distr_data_spell(k,2) = sum(paramdata.data_orig(sel4,3));
        marg_distr_data_spell(k,3) = sum(paramdata.data_orig(sel5,3));   
        marg_distr_data_spell(k,4) = marg_distr_data_spell(k,2) + marg_distr_data_spell(k,3);
    end
    marg_distr_data(:,2) = marg_distr_data(:,2)/sum(marg_distr_data(:,2));
    FINALEST.marg_distr_data = marg_distr_data;
    
    marg_distr_data_spell(:,2)  = marg_distr_data_spell(:,2)/sum(marg_distr_data_spell(:,2));
    marg_distr_data_spell(:,3)  = marg_distr_data_spell(:,3)/sum(marg_distr_data_spell(:,3));
    marg_distr_data_spell(:,4)  = marg_distr_data_spell(:,4)/sum(marg_distr_data_spell(:,4));
    
    
    % model
    tgrid = [0:1:104]';
    for k = 1:GPLUS.K    
        mu = GPLUS.mu_vec(k);
        sigma = GPLUS.sigma_vec(k);    
        %fgrid(:,k) = fct_pdf_f(tgrid,mu,sigma);        
        fgrid(:,k) = (fct_CDF_F_capped(tgrid+1,mu,sigma) -  fct_CDF_F_capped(tgrid,mu,sigma))/fct_CDF_F_capped(105,mu,sigma);            
    end
    marg_distr_model(:,2) = fgrid*GPLUS.g_vec;
    marg_distr_model(:,1) = tgrid;
    FINALEST.marg_distr_model = marg_distr_model;
    
     
    figure(2)
    subplot(1,2,1)
    hold on;
    plot(marg_distr_data_spell(:,1),marg_distr_data_spell(:,2),'b')
    plot(marg_distr_data_spell(:,1),marg_distr_data_spell(:,3),'r')
    legend('first spell','second spell')
    subplot(1,2,2)
    semilogy(marg_distr_data_spell(:,1),marg_distr_data_spell(:,2),'b')
    hold on;
    semilogy(marg_distr_data_spell(:,1),marg_distr_data_spell(:,3),'r')
    legend('first spell','second spell')
    sgtitle('Figure 2: Density of non-employment spell duration')
    
    if output_files_write ==1
        t = tgrid;
        dur_margdistr_data = round(marg_distr_data(:,2),5);
        dur_margdistr_model = round(marg_distr_model(:,2),5);
        tab = table(t,dur_margdistr_data,dur_margdistr_model);
        writetable(tab,'figure_duration_distribution_RP.txt','Delimiter',' ');
    end
    
    if output_files_write ==1
        t = marg_distr_data_spell(:,1);
        dur_margdistr_data_first    = round(marg_distr_data_spell(:,2),5);
        dur_margdistr_data_second   = round(marg_distr_data_spell(:,3),5);      
        tab = table(t,dur_margdistr_data_first,dur_margdistr_data_second);
        writetable(tab,'figure_duration_data_asymetric_RP.txt','Delimiter',' ');
    end

%==========================================================================
% HAZARD RATES FOR LARGEST TYPES
% model
    tgrid = [0:1:104]';
    [A B] = sort(-GPLUS.g_vec);
    for k = 1:10    
        mu = GPLUS.mu_vec(B(k));
        sigma = GPLUS.sigma_vec(B(k))  ;
        HR(k,:) = fct_hazard(tgrid,mu,sigma);    
        
        xx(k,1) = 1/mu;
        xx(k,2) = sigma;
        xx(k,3) = HR(k,end);
        [z zz] = max(HR(k,:));
        xx(k,4) = zz;
        
        alpha_sort(k) = round(mu/sigma,3);
        beta_sort(k) = round(1/sigma,3);
        mu_sort(k) = round(mu,3);
        sigma_sort(k) = round(sigma,3);  
    end
    
    
    figure(3)
    subplot(1,2,1)
    plot(tgrid, HR([1:3],:))
    xlabel('duration in week')
    subplot(1,2,2)
    plot(tgrid, HR([4 :10],:))
    xlabel('duration in week')
    sgtitle('Figure 3: Hazards of 10 types with highest share')
    
    HR = round(HR,5);
    if output_files_write ==1
        duration = tgrid;
        hr1 = HR(1,:)';
        hr2 = HR(2,:)';
        hr3 = HR(3,:)';
        hr4 = HR(4,:)';
        hr5 = HR(5,:)';
        hr6 = HR(6,:)';
        hr7 = HR(7,:)';
        hr8 = HR(8,:)';
        hr9 = HR(9,:)';
        hr10 = HR(10,:)';        
        tab = table(duration,hr1,hr2,hr3,hr4,hr5,...
            hr6,hr7,hr8,hr9,hr10);
        writetable(tab,'individual_hazards_10_types_RP.txt','Delimiter',' ');
    
        type = [1:1:10]';
        share = round(-A(1:10),5);
        tab = table(type,share);
        writetable(tab,'individual_shares_10_types_RP.txt','Delimiter',' ');    
    end

%==========================================================================
% FIGURE FOR MARGINAL DENSITY
    
    figure(4)
    subplot(1,2,1)
    hold on;
    plot(marg_distr_data_spell(:,1),marg_distr_data(:,2),'b')
    plot(marg_distr_data_spell(:,1),marg_distr_model(:,2),'r')
    legend('data','model')
    subplot(1,2,2)
    semilogy(marg_distr_data_spell(:,1),marg_distr_data(:,2),'b')
    hold on;
    semilogy(marg_distr_data_spell(:,1),marg_distr_model(:,2),'r')
    legend('data','model')
    sgtitle('Figure 4: Data and model comparison')

%==========================================================================
% HAZARD RATE DECOMPOSITION
    N  = sum(separate_t);
    N1 = N/paramdata.p1_low*(1-paramdata.p1_low);
    N2 = N/paramdata.p2*(1-paramdata.p2);
    surv_temp = cumsum(separate_t(end:-1:1));
    data_surv = surv_temp(end:-1:1);
    HRdata_p1 = separate_t./(data_surv+N1);
    HRdata_p2 = separate_t./(data_surv+N2);
    
    HRtemp = [GBARdecomp.HR_agg GUSHORTdecomp.HR_agg ...
              GBARWdecomp.HR_agg GUSHORTWdecomp.HR_agg...
              GBARP2decomp.HR_agg GUSHORTP2decomp.HR_agg ...
              GBARP2Wdecomp.HR_agg GUSHORTP2Wdecomp.HR_agg]';
    STRUCtemp = [GBARdecomp.HR_struc_multi GUSHORTdecomp.HR_struc_multi ...
              GBARWdecomp.HR_struc_multi GUSHORTWdecomp.HR_struc_multi...
              GBARP2decomp.HR_struc_multi GUSHORTP2decomp.HR_struc_multi ...
              GBARP2Wdecomp.HR_struc_multi GUSHORTP2Wdecomp.HR_struc_multi]';
    HETERtemp = [GBARdecomp.HR_heter_multi GUSHORTdecomp.HR_heter_multi ...
              GBARWdecomp.HR_heter_multi GUSHORTWdecomp.HR_heter_multi...
              GBARP2decomp.HR_heter_multi GUSHORTP2decomp.HR_heter_multi ...
              GBARP2Wdecomp.HR_heter_multi GUSHORTP2Wdecomp.HR_heter_multi]';
          
    HRlower = min(HRtemp)';          
    HRupper = max(HRtemp)'; 
    STRUClower = min(STRUCtemp)';          
    STRUCupper = max(STRUCtemp)'; 
    HETERlower = min(HETERtemp)';          
    HETERupper = max(HETERtemp)'; 
    
    FINALEST.HRlower = HRlower;
    FINALEST.HRupper = HRupper; 
    FINALEST.STRUClower = STRUClower;          
    FINALEST.STRUCupper = STRUCupper; 
    FINALEST.HETERlower = HETERlower;          
    FINALEST.HETERupper = HETERupper; 
    
    % STANDARD ERRORS
    HR_agg_min_CIlow_rev = 2*FINALEST.HRlower - SE.HR_agg_min_ui;
    HR_agg_min_CIup_rev  = 2*FINALEST.HRlower - SE.HR_agg_min_li;
    HR_agg_max_CIlow_rev = 2*FINALEST.HRupper - SE.HR_agg_max_vec_sort_ui;
    HR_agg_max_CIup_rev  = 2*FINALEST.HRupper - SE.HR_agg_max_vec_sort_li; 
    
    HR_struc_min_CIlow_rev = 2*FINALEST.STRUClower - SE.HR_struc_min_sort_ui;
    HR_struc_min_CIup_rev  = 2*FINALEST.STRUClower - SE.HR_struc_min_sort_li;
    HR_struc_max_CIlow_rev = 2*FINALEST.STRUCupper - SE.HR_struc_max_sort_ui;
    HR_struc_max_CIup_rev  = 2*FINALEST.STRUCupper - SE.HR_struc_max_sort_li;
    
    HR_heter_min_CIlow_rev = 2*FINALEST.HETERlower - SE.HR_heter_min_sort_ui;
    HR_heter_min_CIup_rev  = 2*FINALEST.HETERlower - SE.HR_heter_min_sort_li;
    HR_heter_max_CIlow_rev = 2*FINALEST.HETERupper - SE.HR_heter_max_sort_ui;
    HR_heter_max_CIup_rev  = 2*FINALEST.HETERupper - SE.HR_heter_max_sort_li;
    
    tgrid2 = GBARdecomp.tgrid;
    
    figure(5)
    subplot(1,2,1);hold on;
    plot(tgrid2,HRlower,'m')
    plot(tgrid2,STRUClower,'b')
    plot(tgrid2,HRupper,'m')
    plot(tgrid2,STRUCupper,'b')
    patch([tgrid2' fliplr(tgrid2')],[HRlower' fliplr(HRupper')],'m','LineStyle','none');
    patch([tgrid2' fliplr(tgrid2')],[STRUClower' fliplr(STRUCupper')],'b','LineStyle','none');
    alpha(.2)
    plot(tgrid2,HR_agg_min_CIlow_rev,'m:','LineWidth',1.5)
    plot(tgrid2,HR_agg_max_CIup_rev,'m:','LineWidth',1.5)
    plot(tgrid2,HR_struc_min_CIlow_rev,'b:','LineWidth',1.5)
    plot(tgrid2,HR_struc_max_CIup_rev,'b:','LineWidth',1.5)
    legend('mixture','structural')
    xlabel('duration in weeks')
    ylabel('hazards')
    xlim([1 100])
    
    subplot(1,2,2);
    semilogy(tgrid2,HETERlower,'r')
    hold on;
    semilogy(tgrid2,HETERupper,'r')
    semilogy(tgrid2,HR_heter_min_CIlow_rev,'r:','LineWidth',1.5)
    semilogy(tgrid2,HR_heter_max_CIup_rev,'r:','LineWidth',1.5)
    patch([tgrid2' fliplr(tgrid2')],[HETERlower' fliplr(HETERupper')],'r','LineStyle','none');
    alpha(0.2)
    xlabel('duration in weeks')
    ylabel('heterogeneity effect')
    xlim([1 100])
    sgtitle('Figure 5: Hazard decomposition under distributions in G')   
        
    if output_files_write ==1
        HR_data_min = round(HRdata_p1,5);
        HR_data_max = round(HRdata_p2,5);
        HR_agg_min = round(HRlower,5);
        HR_agg_max = round(HRupper,5);
        HR_struc_min = round(STRUClower,5);
        HR_struc_max = round(STRUCupper,5);
        HR_heter_min = round(HETERlower,5);
        HR_heter_max = round(HETERupper,5);
    
        HR_agg = (HR_agg_min + HR_agg_max )/2;
        HR_struc = (HR_struc_min + HR_struc_max)/2; 
        HR_heter = (HR_heter_min + HR_heter_max)/2 ;
        duration = tgrid2;

        tab = table(duration,HR_agg_min,HR_agg_max,HR_struc_min,HR_struc_max,HR_heter_min,HR_heter_max,...
            HR_agg,HR_struc,HR_heter);        
        writetable(tab,'HR_decomposition_main_RP.txt','Delimiter',' ');  
    end

    if output_files_write ==1
        duration = GBARdecomp.tgrid;
        
        tab = table(duration,HR_agg_min_CIlow_rev,HR_agg_min_CIup_rev,...
           HR_agg_max_CIlow_rev,HR_agg_max_CIup_rev,... 
           HR_struc_min_CIlow_rev,HR_struc_min_CIup_rev,...
           HR_struc_max_CIlow_rev,HR_struc_max_CIup_rev,...
           HR_heter_min_CIlow_rev,HR_heter_min_CIup_rev,...
           HR_heter_max_CIlow_rev,HR_heter_max_CIup_rev );        
        writetable(tab,'HR_decomposition_main_SE_rev_RP.txt','Delimiter',' ');
    end


%==========================================================================
% CONDITIONAL HAZARD IN THE SECOND SPELL
% model
    dt_size  = 1/2; 
    ttgrid = [0:dt_size:104];
    Nt    = length(ttgrid);
    dt = [ttgrid(2)-ttgrid(1) diff(ttgrid)];
                    
    for g = 1:length(Gnames)
    
        G    = eval(cell2mat(Gnames(g)));    
        K    = length(G.g_vec);
    
        Fgrid = zeros(K,Nt);
        fgrid = zeros(K,Nt);
        gsurv = zeros(K,Nt);
        HR  = zeros(K,Nt);
    
        for k = 1:K
            mu    = G.mu_vec(k);
            sigma = G.sigma_vec(k);
            fgrid(k,:) = fct_pdf_f(ttgrid,mu,sigma);
            Fgrid(k,:) = fct_CDF_F_capped(ttgrid,mu,sigma);    
            gsurv(k,:) = G.g_vec(k)*(1-Fgrid(k,:));    
            HR(k,:) = fct_hazard(ttgrid,mu,sigma);  % use fct hazard        
        end
    
        gsum = sum(gsurv,1);
        gsurv = gsurv./repmat(gsum,K,1);
        
        for tindex1 = 1:length(ttgrid)
            % hazard rates
            for tindex2 = 1:length(ttgrid)        
            num(tindex1,tindex2) = (fgrid(:,tindex1).*fgrid(:,tindex2))'*G.g_vec;
            den(tindex1,tindex2) = ((1-Fgrid(:,tindex2)).*fgrid(:,tindex1))'*G.g_vec;       
            end 
            
        end
        
      sel1 = (0<ttgrid) & (ttgrid<5);
      sel2 = (10<=ttgrid) & (ttgrid<15);
      sel3 = (20<=ttgrid) & (ttgrid<25);
      sel4 = (35<=ttgrid) & (ttgrid<40);
      
      HRcond_bin(1,:) = sum(num(sel1,:))./sum(den(sel1,:));
      HRcond_bin(2,:) = sum(num(sel2,:))./sum(den(sel2,:));
      HRcond_bin(3,:) = sum(num(sel3,:))./sum(den(sel3,:));
      HRcond_bin(4,:) = sum(num(sel4,:))./sum(den(sel4,:));
      
      HRcond_bin_1(:,g) = HRcond_bin(1,:)';
      HRcond_bin_2(:,g) = HRcond_bin(2,:)';
      HRcond_bin_3(:,g) = HRcond_bin(3,:)';
      HRcond_bin_4(:,g) = HRcond_bin(4,:)';
    
      
    end
    
    HR1_min = min(HRcond_bin_1')';
    HR1_max = max(HRcond_bin_1')';
    HR2_min = min(HRcond_bin_2')';
    HR2_max = max(HRcond_bin_2')';
    HR3_min = min(HRcond_bin_3')';
    HR3_max = max(HRcond_bin_3')';
    HR4_min = min(HRcond_bin_4')';
    HR4_max = max(HRcond_bin_4')';
    
    % data
    %raw = load('IG_raw_0_105_RP.txt');
    Tbar = 104;
    Tmin = 0;
    Tmax = Tbar;
    
    sel = raw(:,2)<300;
    data = raw(sel,:);
    
    for t = Tmin:Tmax
        tindex = t-Tmin+1;
        sel = data(:,1)==t;
        for t1 = Tmin:Tmax
            t1index = t1-Tmin+1;
            selN  = (data(:,2)==t1).*sel;
            selD  = (data(:,2)>=t1).*sel;        
            
            HR(t1index,tindex)= sum(data(selN==1,3))/sum(data(selD==1,3));        
        end    
        
    end
    
    window5 = [0,10,15,20,25,30,35,40,45,50,55];
    for j = 1:length(window5)    
        sel = (data(:,1)>=window5(j)) & (data(:,1)< window5(j)+5);
           
        for t1 = Tmin:Tmax
            t1index = t1-Tmin+1;
            selN  = (data(:,2)==t1).*sel;
            selD  = (data(:,2)>=t1).*sel;        
            
            HRw(t1index,j)= sum(data(selN==1,3))/sum(data(selD==1,3));        
        end    
        
    end
    
    
    figure(7)
    subplot(1,2,1);hold on;
    plot(HRw(:,1),'r');
    plot(HRw(:,2),'b');
    plot(HRw(:,4),'g');
    plot(HRw(:,7),'k');
    xlabel('duration in weeks')
    ylabel('hazards')
    legend('0 <=t1<=4','10<=t1<=14','20<=t1<=24','35<=t1<=39')
    ylim([0 0.14])
    
    subplot(1,2,2);hold on;
    plot(ttgrid,HR1_min,'r')
    plot(ttgrid,HR1_max,'r')
    plot(ttgrid,HR2_min,'b')
    plot(ttgrid,HR2_max,'b')
    plot(ttgrid,HR3_min,'g')
    plot(ttgrid,HR3_max,'g')
    plot(ttgrid,HR4_min,'k')
    plot(ttgrid,HR4_max,'k')
    patch([ttgrid fliplr(ttgrid)],[HR1_min' fliplr(HR1_max')],'r','LineStyle','none');
    patch([ttgrid fliplr(ttgrid)],[HR2_min' fliplr(HR2_max')],'b','LineStyle','none');
    patch([ttgrid fliplr(ttgrid)],[HR3_min' fliplr(HR3_max')],'g','LineStyle','none');
    patch([ttgrid fliplr(ttgrid)],[HR4_min' fliplr(HR4_max')],'k','LineStyle','none');
    alpha(0.2)
    xlabel('duration in weeks')
    ylabel('hazards')
    ylim([0 0.14])
    title('Model')
    sgtitle('Figure 7: Mixture hazard for the second spell')


    % OUTPUT
    
    HR0 = round(HRw(:,1),5);
    HR10 = round(HRw(:,2),5);
    HR20 = round(HRw(:,4),5);
    HR35 = round(HRw(:,7),5);
   
    HR0_min = round(HR1_min,5);
    HR0_max = round(HR1_max,5);
    HR10_min= round(HR2_min,5);
    HR10_max= round(HR2_max,5);
    HR20_min= round(HR3_min,5);
    HR20_max= round(HR3_max,5);
    HR35_min= round(HR4_min,5);
    HR35_max= round(HR4_max,5);
    

    if output_files_write ==1
        duration =  [Tmin:1:Tmax]';        
        tab = table(duration,HR0,HR10,HR20,HR35);
        writetable(tab,'MPH_HR_dominance_RP.txt','Delimiter',' ');

        duration = ttgrid';
        tab = table(duration,HR0_min,HR0_max,HR10_min,HR10_max,...
            HR20_min,HR20_max,HR35_min,HR35_max);
        writetable(tab,'IG_HR_dominance_RP.txt','Delimiter',' ');
    end




%==========================================================================
% DISTRIBUTION OF FIXED COSTS
    mu_e = 0.01;
    mu_n = 3.7*mu_e;
    sigma_e = 0.05;
    r = 0.02;
    
    for g = 1:length(Gnames)
        G     = eval(cell2mat(Gnames(g)));
        mu_vec    = G.mu_vec*52;
        sigma_vec = G.sigma_vec*sqrt(52);
        alpha_vec = mu_vec./sigma_vec;
        beta_vec = 1./sigma_vec;
        
        FC_term1 = (mu_e + sqrt(mu_e^2 + 2*r*sigma_e^2))*mu_n^2/(12*r*sigma_e^2);
        FC_term2 = (-alpha_vec + sqrt(alpha_vec.^2 +2*r)).*beta_vec.^3./alpha_vec.^2;
        psi_e_vec = FC_term1*FC_term2;
        [x xx] = max(psi_e_vec);
        psi_max(g) = xx;
        
        % statistics
        [A B] = sort(psi_e_vec);
        psi_e_sort = [A G.g_vec(B)];
        psi_e_mean = psi_e_sort(:,1)'*psi_e_sort(:,2);
        psi_e_var = (psi_e_sort(:,1)'-psi_e_mean).^2*psi_e_sort(:,2);
        psi_e_cs = cumsum(psi_e_sort(:,2));
        [C D] = min(abs(psi_e_cs-0.5));
        psi_e_median = psi_e_sort(D,1);
        [C D] = min(abs(psi_e_cs-0.1));
        psi_e_10 = psi_e_sort(D,1);
        [C D] = min(abs(psi_e_cs-0.9));
        psi_e_90 = psi_e_sort(D,1);
        
        psi_e_sort_all(1:length(psi_e_cs),g) = psi_e_cs;
        psi_e_grid_all(1:length(psi_e_cs),g) = psi_e_sort(:,1);
        
    end
    
    xx = psi_e_grid_all(:);
    FCmin = min(xx(xx~=0));
    FCmax = max(psi_e_grid_all(:));
    grid_common = sort(unique(xx(xx~=0)));
    psi_e_common_grid = zeros(length(grid_common),8);
    
    for i = 1:8
        x = psi_e_grid_all(:,i);
        v = psi_e_sort_all(:,i);
        sel = (x~=0);
        x = x(sel);
        v = v(sel);
        
        C = setdiff(grid_common,x);
    
        beg1 = 1;
        beg2 = 1;        
        for s = 1:length(C)        
           [m mm] = min(abs(grid_common-C(s))) ;
           if mm == 1
               psi_e_common_grid(1,i) = 0;
               beg1 = 2;           
           else
               end2 = beg2-1+mm-1-beg1+1;
               psi_e_common_grid(beg1:mm-1,i) = v(beg2:end2);
               psi_e_common_grid(mm,i) = psi_e_common_grid(mm-1,i);
               beg1 = mm+1;
               beg2 = end2+1;
           end
        end
        
        if mm < length(grid_common)
            mm = length(grid_common);
            end2 = beg2-1+mm-beg1+1;
            psi_e_common_grid(beg1:mm,i) = v(beg2:end2);
        end
    
    end
    
        psi_e = round(grid_common,8);
        CDF_min = round( min(psi_e_common_grid')',8);
        CDF_max = round( max(psi_e_common_grid')',8);
        
        psi_add = round(psi_e(1)^2/psi_e(2),8);
        FC_psi_e = [psi_add; psi_e];
        FC_CDF_min = [0;CDF_min];
        FC_CDF_max = [0;CDF_max];
    
    if output_files_write ==1    
        tab = table(FC_psi_e,FC_CDF_min,FC_CDF_max);        
        writetable(tab,'fixed_costs_distribution_RP.txt','Delimiter',' ');
    end
    
    for g = 1:length(Gnames)
        G     = eval(cell2mat(Gnames(g)));
        mu_vec    = G.mu_vec*52;
        sigma_vec = G.sigma_vec*sqrt(52);
        % width of inaction region
        IR = abs(mu_n./mu_vec);
        [AA BB] = sort(IR);
        IR_sort = [AA G.g_vec(BB)];
        IR_sort_cs = cumsum(IR_sort(:,2));
        [CC DD] = min(abs(IR_sort_cs-0.5));
        IR_median = IR_sort(DD,1);
        IR_mean =  IR_sort(:,1)'*IR_sort(:,2);    
        
        IR_cs_all(1:length(IR),g) = IR_sort_cs;
        IR_grid_all(1:length(IR),g) = IR_sort(:,1);
    end
    
    xx = IR_grid_all(:);
    IR_grid_common = sort(unique(xx(xx~=0)));
    IR_distr_common_grid = zeros(length(IR_grid_common),8);
    
    for i = 1:8
        x = IR_grid_all(:,i);
        v = IR_cs_all(:,i);
        sel = (x~=0);
        x = x(sel);
        v = v(sel);    
        
        % take care of a non-unique grid
        sel = ones(length(x),1);
        sel(1:end-1) = (x(1:end-1)~=x(2:end));
        
        x = x(sel==1);
        v = v(sel==1);
        
        C = setdiff(IR_grid_common,x);
    
        if size(C,1)==0
            IR_distr_common_grid(:,i) = v;
        else
            beg1 = 1;
            beg2 = 1;        
            for s = 1:length(C)        
               [m mm] = min(abs(IR_grid_common-C(s))) ;
               if mm == 1
                   psi_e_common_grid(1,i) = 0;
                   beg1 = 2;           
               else
                   end2 = beg2-1+mm-1-beg1+1;
                   IR_distr_common_grid(beg1:mm-1,i) = v(beg2:end2);
                   IR_distr_common_grid(mm,i) = IR_cs_all(mm-1,i);
                   beg1 = mm+1;
                   beg2 = end2+1;
               end
            end
    
            if mm < length(IR_grid_common)
                mm = length(IR_grid_common);
                end2 = beg2-1+mm-beg1+1;
                IR_distr_common_grid(beg1:mm,i) = v(beg2:end2);
            end
        end
    
    end
    
        IR = round(IR_grid_common,8);
        CDF_min = round( min(IR_distr_common_grid')',8);
        CDF_max = round( max(IR_distr_common_grid')',8);
        
        IRadd = 2*IR_grid_common(1)-IR_grid_common(2);
        IR_grid = [IRadd;IR];
        IR_CDF_min = [0;CDF_min];
        IR_CDF_max = [0;CDF_max];
        
    if output_files_write ==1    
        tab = table(IR_grid,IR_CDF_min,IR_CDF_max);        
        writetable(tab,'inaction_region_distribution_RP.txt','Delimiter',' ');
    end


    FC_grid_long_temp = repmat(FC_psi_e(2:end),1,2);
    FC_grid_long_temp = FC_grid_long_temp';
    FC_grid_long_temp = FC_grid_long_temp(:);
    FC_grid_long = [FC_psi_e(1); FC_grid_long_temp ;FC_psi_e(end)];
    FC_CDF_min_long_temp = repmat(FC_CDF_min,1,2);
    FC_CDF_min_long_temp = FC_CDF_min_long_temp';
    FC_CDF_min_long = FC_CDF_min_long_temp(:);
    FC_CDF_max_long_temp = repmat(FC_CDF_max,1,2);
    FC_CDF_max_long_temp = FC_CDF_max_long_temp';
    FC_CDF_max_long = FC_CDF_max_long_temp(:);
    
    IR_grid_long_temp = repmat(IR_grid(2:end),1,2);
    IR_grid_long_temp = IR_grid_long_temp';
    IR_grid_long_temp = IR_grid_long_temp(:);
    IR_grid_long = [IR_grid(1); IR_grid_long_temp ;IR_grid(end)];
    IR_CDF_min_long_temp = repmat(IR_CDF_min,1,2);
    IR_CDF_min_long_temp = IR_CDF_min_long_temp';
    IR_CDF_min_long = IR_CDF_min_long_temp(:);
    IR_CDF_max_long_temp = repmat(IR_CDF_max,1,2);
    IR_CDF_max_long_temp = IR_CDF_max_long_temp';
    IR_CDF_max_long = IR_CDF_max_long_temp(:);
    
    figure(8)
    subplot(1,2,1); 
    semilogx(FC_grid_long,FC_CDF_min_long,'m')
    hold on;
    semilogx(FC_grid_long,FC_CDF_max_long,'m')
    patch([FC_grid_long' fliplr(FC_grid_long')],[FC_CDF_min_long' fliplr(FC_CDF_max_long')],[0.7 0.0 1.0],'EdgeColor',[0.7 0.0 1.0]);
    xlabel('fixed costs')
    ylabel('CDF')
    
    subplot(1,2,2); 
    patch([IR_grid_long' fliplr(IR_grid_long')],[IR_CDF_min_long' fliplr(IR_CDF_max_long')],[0.8 0.0 0.0],'EdgeColor',[0.8 0.0 0.0]);
    hold on;
    plot(IR_grid_long,IR_CDF_min_long,'r')
    plot(IR_grid_long,IR_CDF_max_long,'r')
    xlabel('width of inaction region')
    ylabel('CDF')
    sgtitle('Figure 8: Fixed costs and width of inaction region')
    
    
    %==========================================================================
    % SHARE OF WORKERS WITH NEGATIVE APLHA
    neg_share_min = 1;
    neg_share_max = 0;
    for g = 1:8
        G     = eval(cell2mat(Gnames(g)));
        neg_share_min = min(G.neg_share,neg_share_min);
        neg_share_max = max(G.neg_share,neg_share_max);
    end
    fprintf('Share of workers with negative alpha lies between %5.3f and %5.3f \n', neg_share_min,neg_share_max)


%==========================================================================
% SHARE OF WORKERS WITH NEGATIVE APLHA
    prob_incomplete = zeros(8,1);
    for g = 1:8
        G     = eval(cell2mat(Gnames(g)));
        sel = G.mu_vec<0;    
        muneg = G.mu_vec(sel);
        sigmaneg = G.sigma_vec(sel);
        gneg = G.g_vec(sel);
        prob_incomplete(g) = (1-exp(2*muneg./sigmaneg.^2))'*gneg;    
    end
    
    fprintf('Share of workers with negative alpha lies between %5.2f and %5.2f \n', min(prob_incomplete),max(prob_incomplete))


%==========================================================================
% CONDITIONAL DISTRIBUTION OF DURATIONS
% data
    k=0;
    for t = 0:104
        k = k+1;
        sel0 = (paramdata.data(:,1)==13) ;% & (paramdata.data(:,2)<105);
        sel1 = (paramdata.data(:,1)==14);% & (paramdata.data(:,2)<105);
        sel2 = (paramdata.data(:,1)==26);% & (paramdata.data(:,2)<105);
        sel3 = (paramdata.data(:,1)==27) ;%& (paramdata.data(:,2)<105);
       
        
        cond_distr_data0(:,1) = paramdata.data(sel0,2);
        cond_distr_data0(:,2) = paramdata.data(sel0,3);%/sum(paramdata.data(sel0,3));
        cond_distr_data1(:,1) = paramdata.data(sel1,2);
        cond_distr_data1(:,2) = paramdata.data(sel1,3);%/sum(paramdata.data(sel1,3));
        cond_distr_data2(:,1) = paramdata.data(sel2,2);
        cond_distr_data2(:,2) = paramdata.data(sel2,3);%/sum(paramdata.data(sel2,3));
        cond_distr_data3(:,1) = paramdata.data(sel3,2);
        cond_distr_data3(:,2) = paramdata.data(sel3,3);%/sum(paramdata.data(sel3,3));
    end
    
    if output_files_write ==1
        t = cond_distr_data0(1:end-1,1);
        cond_distr_data_t13  = round(cond_distr_data0(1:end-1,2),5);
        cond_distr_data_t14 = round(cond_distr_data1(1:end-1,2),5);
        cond_distr_data_t26 = round(cond_distr_data2(1:end-1,2),5);
        cond_distr_data_t27 = round(cond_distr_data3(1:end-1,2),5);
        tab = table(t,cond_distr_data_t13,cond_distr_data_t14,cond_distr_data_t26,cond_distr_data_t27);
        writetable(tab,'figure_duration_conditional_distribution_2_RP.txt','Delimiter',' ');
    end


%==========================================================================
% JOINT DISTRIBUTION OF SPELLS: DATA
    sel = (paramdata.data_sym(:,1)<=80 ) &  (paramdata.data_sym(:,2)<=80 );
    if output_files_write ==1
        duration1 = paramdata.data_sym(sel,1);
        duration2 = paramdata.data_sym(sel,2);
        people = paramdata.data_sym(sel,3);
        tab = table(duration1,duration2,people);
        writetable(tab,'duration_0_80_joint_distribution_RP.txt','Delimiter',' ');
    end
    
    % IMPORTANCE OF THE DIAGONAL
    for t = 1:52
        sel = (paramdata.data_sym(:,1)==t) & (paramdata.data_sym(:,2)==t);
        pp1(t) = sum(paramdata.data_sym(sel,3));
        
        sel2 = (paramdata.data_sym(:,1)==t) & (paramdata.data_sym(:,2)==t-1);
        sel3 = (paramdata.data_sym(:,1)==t) & (paramdata.data_sym(:,2)==t+1);
        
        pp2(t) = 0.5*(sum(paramdata.data_sym(sel2,3))+ sum(paramdata.data_sym(sel3,3)));    
    end
    
    fprintf('Ridge: average value of the log difference %5.3f \n', mean(log(pp1)-log(pp2))) 
    
    sel = (paramdata.data_sym(:,1)<=80 ) &  (paramdata.data_sym(:,2)<=80 );
    d1 = reshape(paramdata.data_sym(sel,1),81,81);
    d2 = reshape(paramdata.data_sym(sel,2),81,81);
    people_surf = reshape(paramdata.data_sym(sel,3),81,81);
        
    figure(9); 
    obj = surf(d1,d2,(people_surf));
    %colormap(gray(50));
    rotate(obj,[0 0 1],180)
    h = gca;
    set(h,'zscale','log')
    xlim([0 80])
    ylim([0 80])
    xlabel('duration in weeks')
    ylabel('duration in weeks')
    zlabel('number of individuals')
    title('Figure 9: Non-employment exit joint density ...')


%==========================================================================
% CONDITIONAL DISTRIBUTION OF DURATIONS - SMOOTH DATA 

    phi = reshape(paramdata.data_sym(:,3),105,105);
    phi_smooth = fct_HP_2dim_triangular(phi,1);
    phi_smooth_vec = phi_smooth(:);
    data_smooth_incomplete = paramdata.data_sym;
    data_smooth_incomplete(:,3) = phi_smooth_vec;
    % append incomplete spells
    sel = (paramdata.data(:,1)>104) | (paramdata.data(:,2)>104);
    mat_add = paramdata.data(sel,:);
    data_smooth_incomplete = [data_smooth_incomplete;mat_add];
    [A B] = sortrows(data_smooth_incomplete,[1 2]);
    data_smooth_incomplete = A;
        
    k=0;
    for t = 0:104
        k = k+1;
        sel0 = (data_smooth_incomplete(:,1)==13) ;% & (paramdata.data(:,2)<105);
        sel1 = (data_smooth_incomplete(:,1)==14);% & (paramdata.data(:,2)<105);
        sel2 = (data_smooth_incomplete(:,1)==26);% & (paramdata.data(:,2)<105);
        sel3 = (data_smooth_incomplete(:,1)==27) ;%& (paramdata.data(:,2)<105);
        
        
        cond_distr_smooth_data0(:,1) = data_smooth_incomplete(sel0,2);
        cond_distr_smooth_data0(:,2) = data_smooth_incomplete(sel0,3);%/sum(paramdata.data(sel0,3));
        cond_distr_smooth_data1(:,1) = data_smooth_incomplete(sel1,2);
        cond_distr_smooth_data1(:,2) = data_smooth_incomplete(sel1,3);%/sum(paramdata.data(sel1,3));
        cond_distr_smooth_data2(:,1) = data_smooth_incomplete(sel2,2);
        cond_distr_smooth_data2(:,2) = data_smooth_incomplete(sel2,3);%/sum(paramdata.data(sel2,3));
        cond_distr_smooth_data3(:,1) = data_smooth_incomplete(sel3,2);
        cond_distr_smooth_data3(:,2) = data_smooth_incomplete(sel3,3);%/sum(paramdata.data(sel3,3));
    end
    
    if output_files_write ==1
        duration = cond_distr_smooth_data0(1:end-1,1);
        cond_distr_smooth_data_t13  = round(cond_distr_smooth_data0(1:end-1,2),5);
        cond_distr_smooth_data_t14 = round(cond_distr_smooth_data1(1:end-1,2),5);
        cond_distr_smooth_data_t26 = round(cond_distr_smooth_data2(1:end-1,2),5);
        cond_distr_smooth_data_t27 = round(cond_distr_smooth_data3(1:end-1,2),5);
        tab = table(duration,cond_distr_smooth_data_t13,cond_distr_smooth_data_t14,cond_distr_smooth_data_t26,cond_distr_smooth_data_t27);
        writetable(tab,'figure_duration_conditional_smooth_distribution_2_RP.txt','Delimiter',' ');
    end
    
    figure(10)
    subplot(2,2,1)
    semilogy(cond_distr_smooth_data0(1:end-1,1),cond_distr_smooth_data0(1:end-1,2),'r')
    hold on;
    semilogy(cond_distr_data0(1:end-1,1),(cond_distr_data0(1:end-1,2)),'k')
    title('t1 = 13')
    subplot(2,2,2)
    semilogy(cond_distr_smooth_data1(1:end-1,1),cond_distr_smooth_data1(1:end-1,2),'r')
    hold on;
    semilogy(cond_distr_data1(1:end-1,1),(cond_distr_data1(1:end-1,2)),'k')
    title('t1 = 14')
    subplot(2,2,3)
    semilogy(cond_distr_smooth_data2(1:end-1,1),cond_distr_smooth_data2(1:end-1,2),'r')
    hold on;
    semilogy(cond_distr_data2(1:end-1,1),(cond_distr_data2(1:end-1,2)),'k')
    title('t1 = 26')
    subplot(2,2,4)
    semilogy(cond_distr_smooth_data3(1:end-1,1),cond_distr_smooth_data3(1:end-1,2),'r')
    hold on;
    semilogy(cond_distr_data3(1:end-1,1),(cond_distr_data3(1:end-1,2)),'k')
    title('t1 = 27')
    sgtitle('Figure 10: Non-emp. duration of second spell conditional first')
    
    
    %==========================================================================
    % CONDITIONAL DISTRIBUTION OF DURATIONS -- MODEL IMPLIED
    % model
    tgrid = [0:1:104]';
    clear fgrid Fgrid
    for k = 1:GPLUS.K    
        mu = GPLUS.mu_vec(k);
        sigma = GPLUS.sigma_vec(k);    
        %fgrid(:,k) = fct_pdf_f(tgrid,mu,sigma);        
        fgridX(:,k) = (fct_CDF_F_capped(tgrid+1,mu,sigma) -  fct_CDF_F_capped(tgrid,mu,sigma))/fct_CDF_F_capped(105,mu,sigma);            
        fgrid(:,k) = (fct_CDF_F_capped(tgrid+1,mu,sigma) -  fct_CDF_F_capped(tgrid,mu,sigma));
        Fgrid(k,1) = fct_CDF_F_capped(105,mu,sigma);            
    end
    
    % model, joint distribution
    NT = length(tgrid);
    joint_distr_model_num = zeros(NT,NT);
    for k = 1:GPLUS.K   
        temp = fgrid(:,k).*fgrid(:,k)'*GPLUS.g_vec(k);
        joint_distr_model_num = joint_distr_model_num + temp;
    end
    
    joint_distr_model = joint_distr_model_num/(GPLUS.g_vec'*Fgrid.^2);
    joint_distr_vec(:,1:2) = paramdata.data_sym(:,1:2);
    joint_distr_vec(:,3) = joint_distr_model(:); 
    
    phi_data =  paramdata.data_sym(:,3)/sum( paramdata.data_sym(:,3));
    
    Fmeasure = 1-var(phi_data - joint_distr_vec(:,3))/var(phi_data);
    fprintf('Share of variation in the data explained %5.3f \n',Fmeasure) 

%==========================================================================
% VALUE FUNCTIONS: (FIGURE 12)
    % parameters
    VFparam.bar_sigma = 0.1;  % bar sigma : volatility of log wages
    VFparam.til_sigma = 0.04;  % tilde sigma : volatility of log (latent) wages
    VFparam.bar_mu  = 0.02 ;    % bar mu : drift of log wages
    VFparam.til_mu  = 0.01;    % tilde mu : drift of latent wages
    
    VFparam.rho = 0.04;  % discount rate
    VFparam.b   = 1;    % flow value of non-employment
    VFparam.ppsi = 2;  % fixed cost to go fron non-employment to enmployment

    out = fct_value_functions(VFparam);

%==========================================================================
% DECOMPOSITION WIH OBSERVABLES
    %decomposition_observables_RP
    out = fct_decomposition_observables(FINALEST,observables, output_files_write);

%==========================================================================
% ALTERNATIVE DATA SELECTION
    load estimates_RP_T260.mat
    
    HRtemp = [GBARdecomp.HR_agg GUSHORTdecomp.HR_agg ...
              GBARWdecomp.HR_agg GUSHORTWdecomp.HR_agg...
              GBARP2decomp.HR_agg GUSHORTP2decomp.HR_agg ...
              GBARP2Wdecomp.HR_agg GUSHORTP2Wdecomp.HR_agg]';
    STRUCtemp = [GBARdecomp.HR_struc_multi GUSHORTdecomp.HR_struc_multi ...
              GBARWdecomp.HR_struc_multi GUSHORTWdecomp.HR_struc_multi...
              GBARP2decomp.HR_struc_multi GUSHORTP2decomp.HR_struc_multi ...
              GBARP2Wdecomp.HR_struc_multi GUSHORTP2Wdecomp.HR_struc_multi]';
    HETERtemp = [GBARdecomp.HR_heter_multi GUSHORTdecomp.HR_heter_multi ...
              GBARWdecomp.HR_heter_multi GUSHORTWdecomp.HR_heter_multi...
              GBARP2decomp.HR_heter_multi GUSHORTP2decomp.HR_heter_multi ...
              GBARP2Wdecomp.HR_heter_multi GUSHORTP2Wdecomp.HR_heter_multi]';
          
    HRlower261 = min(HRtemp)';          
    HRupper261 = max(HRtemp)'; 
    STRUClower261 = min(STRUCtemp)';          
    STRUCupper261 = max(STRUCtemp)'; 
    HETERlower261 = min(HETERtemp)';          
    HETERupper261 = max(HETERtemp)'; 
    
    tgrid3 = GBARdecomp.tgrid;
    
    figure(13)
    subplot(1,2,1);hold on;
    plot(tgrid3,HRlower261,'m')
    plot(tgrid3,STRUClower261,'b')
    plot(tgrid3,HRupper261,'m')
    plot(tgrid3,STRUCupper261,'b')
    patch([tgrid3' fliplr(tgrid3')],[HRlower261' fliplr(HRupper261')],'m','LineStyle','none');
    patch([tgrid3' fliplr(tgrid3')],[STRUClower261' fliplr(STRUCupper261')],'b','LineStyle','none');
    alpha(.2)
    legend('mixture','structural')
    xlabel('duration in weeks')
    ylabel('hazards')
    xlim([1 100])
    
    subplot(1,2,2);
    semilogy(tgrid3,HETERlower261,'r')
    hold on;
    semilogy(tgrid2,HETERlower,'color',[0 0.2 0])
    semilogy(tgrid3,HETERupper261,'r')
    semilogy(tgrid2,HETERupper,'color',[0 0.2 0])
    patch([tgrid3' fliplr(tgrid3')],[HETERlower261' fliplr(HETERupper261')],'r','LineStyle','none');
    patch([tgrid2' fliplr(tgrid2')],[HETERlower' fliplr(HETERupper')],[0 0.2 0],'LineStyle','none');
    alpha(0.2)
    legend('260 weeks','104 weeks')
    xlabel('duration in weeks')
    ylabel('heterogeneity effect')
    xlim([1 100])
    sgtitle('Figure 13: Hazard decomposition under distributions in G')  



    if output_files_write ==1
        duration = GBARdecomp.tgrid;
    
        HR_agg_min = round(HRlower261,5);
        HR_agg_max = round(HRupper261,5);
        HR_agg_mean = round((HRlower261+HRupper261)/2,5);
        HR_struc_min = round(STRUClower261,5);
        HR_struc_max = round(STRUCupper261,5);
        HR_struc_mean = round((STRUClower261+STRUCupper261)/2,5);
        HR_heter_min = round(HETERlower261,5);
        HR_heter_max = round(HETERupper261,5);
        HR_heter_mean = round((HETERlower261+HETERupper261)/2,5);
        
    
        tab = table(duration,HR_agg_min,HR_agg_max,HR_agg_mean,...
            HR_struc_min,HR_struc_max,HR_struc_mean,...
            HR_heter_min,HR_heter_max,HR_heter_mean);
        writetable(tab,'HR_decomposition_main_261_RP.txt','Delimiter',' ')
    end


%==========================================================================
% TABLE 1
    gg   = FINALEST.GPLUS.g_vec;
    mmu  = FINALEST.GPLUS.mu_vec;
    ssig = FINALEST.GPLUS.sigma_vec;
    aalp = mmu./ssig;
    bbet = 1./ssig;
    bet_alp = 1./mmu;
    bet_alp3 = bet_alp.^3;
    alp2_inv = 2./aalp.^2;

    OUTmu = fct_vec_statistics(mmu,gg);    
    OUTsig = fct_vec_statistics(ssig,gg);   
    OUTalp = fct_vec_statistics(aalp,gg);   
    OUTbet = fct_vec_statistics(bbet,gg);   
    OUTbetalp = fct_vec_statistics(bet_alp,gg);   
    OUT2alp2 = fct_vec_statistics(alp2_inv,gg);   
    OUTbetalp3 = fct_vec_statistics(bet_alp3,gg);   

    disp(' ')
    disp(' ')
    disp(' ')
    disp('---------------------------------------------------------------')
    disp('Table 1:  Summary statistics for G+ ')        
    fprintf('                   mean   st.dev.    min      \n')
    disp('---------------------------------------------------------------')
    fprintf('alpha             %7.3f %7.3f %7.3f  \n',OUTalp.mean_x,OUTalp.std_x,OUTalp.min_x);
    fprintf('beta              %7.3f %7.3f %7.3f  \n',OUTbet.mean_x,OUTbet.std_x,OUTbet.min_x);
    fprintf('mu                %7.3f %7.3f %7.3f  \n',OUTmu.mean_x,OUTmu.std_x,OUTmu.min_x);
    fprintf('sigma             %7.3f %7.3f %7.3f  \n',OUTsig.mean_x,OUTsig.std_x,OUTsig.min_x);
    fprintf('beta/alpha        %7.3f %7.3f %7.3f  \n',OUTbetalp.mean_x,OUTbetalp.std_x,OUTbetalp.min_x);
    fprintf('2/alpha^2         %7.3f %7.3f %7.3f  \n',OUT2alp2.mean_x,OUT2alp2.std_x,OUT2alp2.min_x);
    fprintf('(beta/alpha)^3    %7.0f %7.0f %7.0f  \n',OUTbetalp3.mean_x,OUTbetalp3.std_x,OUTbetalp3.min_x);

%==========================================================================
% ACCURACY OF THE EM ALGORITHM

    % this function merges two structures
    mergestructs = @(x,y)cell2struct([struct2cell(x);struct2cell(y)],[fieldnames(x);fieldnames(y)]);

    load('accuracy_sample1_RP_GPLUStrue.mat');
    GPLUStruedecomp1 = GPLUStruedecomp;    
    OUT             = fct_G_statistics(GPLUStrue);
    GPLUStrue1      = mergestructs(GPLUStrue,OUT);    
    clear OUT
    
    load('accuracy_sample1_RP.mat');     
    GPLUSdecomp1 = GPLUSdecomp;
    OUT    = fct_G_statistics(GPLUS);
    GPLUS1 = mergestructs(GPLUS,OUT);
    clear OUT
        
    load('accuracy_sample2_RP_GPLUStrue.mat');
    GPLUStruedecomp2 = GPLUStruedecomp;    
    OUT             = fct_G_statistics(GPLUStrue);
    GPLUStrue2      = mergestructs(GPLUStrue,OUT);    
    clear OUT
    
    load('accuracy_sample2_RP.mat'); 
    GPLUSdecomp2 = GPLUSdecomp;
    OUT    = fct_G_statistics(GPLUS);
    GPLUS2 = mergestructs(GPLUS,OUT);
    clear OUT
    
    load('accuracy_sample3_RP_GPLUStrue.mat');
    GPLUStruedecomp3 = GPLUStruedecomp;
    OUT             = fct_G_statistics(GPLUStrue);
    GPLUStrue3      = mergestructs(GPLUStrue,OUT);    
    clear OUT
    
    load('accuracy_sample3_RP.mat'); 
    GPLUSdecomp3 = GPLUSdecomp;
    OUT    = fct_G_statistics(GPLUS);
    GPLUS3 = mergestructs(GPLUS,OUT);
    clear OUT


        figure(14); 
        subplot(3,2,1)
        hold on;
        plot(GPLUSdecomp1.tgrid, GPLUSdecomp1.HR_agg,'m')
        plot(GPLUSdecomp1.tgrid, GPLUSdecomp1.HR_struc_multi,'b')
        plot(GPLUStruedecomp1.tgrid, GPLUStruedecomp1.HR_agg,'m--')
        plot(GPLUStruedecomp1.tgrid, GPLUStruedecomp1.HR_struc_multi,'b--')
        xlabel('duration in weeks')
        ylabel('hazards')
        ylim([0 0.1])
        subplot(3,2,2)    
        semilogy(GPLUSdecomp1.tgrid, GPLUSdecomp1.HR_heter_multi,'r')
        hold on;
        semilogy(GPLUStruedecomp1.tgrid, GPLUStruedecomp1.HR_heter_multi,'r--')
        ylim([0.1 1])
        xlabel('duration in weeks')
        ylabel('heterogeneity effect')
    
        subplot(3,2,3)
        hold on;
        plot(GPLUSdecomp2.tgrid, GPLUSdecomp2.HR_agg,'m')
        plot(GPLUSdecomp2.tgrid, GPLUSdecomp2.HR_struc_multi,'b')
        plot(GPLUStruedecomp2.tgrid, GPLUStruedecomp2.HR_agg,'m--')
        plot(GPLUStruedecomp2.tgrid, GPLUStruedecomp2.HR_struc_multi,'b--')
        xlabel('duration in weeks')
        ylabel('hazards')
        ylim([0 0.1])
    
        subplot(3,2,4)    
        semilogy(GPLUSdecomp2.tgrid, GPLUSdecomp2.HR_heter_multi,'r')
        hold on;
        semilogy(GPLUStruedecomp2.tgrid, GPLUStruedecomp2.HR_heter_multi,'r--')
        ylim([0.1 1])
        xlabel('duration in weeks')
        ylabel('heterogeneity effect')
    
        subplot(3,2,5)
        hold on;
        plot(GPLUSdecomp3.tgrid, GPLUSdecomp3.HR_agg,'m')
        plot(GPLUSdecomp3.tgrid, GPLUSdecomp3.HR_struc_multi,'b')
        plot(GPLUStruedecomp3.tgrid, GPLUStruedecomp3.HR_agg,'m--')
        plot(GPLUStruedecomp3.tgrid, GPLUStruedecomp3.HR_struc_multi,'b--')
        xlabel('duration in weeks')
        ylabel('hazards')
        ylim([0 0.2])
    
        subplot(3,2,6)    
        semilogy(GPLUSdecomp3.tgrid, GPLUSdecomp3.HR_heter_multi,'r')
        hold on;
        semilogy(GPLUStruedecomp3.tgrid, GPLUStruedecomp3.HR_heter_multi,'r--')
        ylim([0.1 1])
        xlabel('duration in weeks')
        ylabel('heterogeneity effect')
        sgtitle('Figure 14: Numerical accuracy of our estimation method. ')
    

        disp(' ')
        disp(' ')
        disp(' ')
        disp('---------------------------------------------------------------')
        disp('Table 3: Comparison of summary statistics')    
        fprintf('            true distribution                      estimated distribution  \n')
        fprintf('        mean   median   st.dev.    min      mean   median   st.dev.   min \n')
        disp('----distribution G1 -------------------------------------------------------')
        fprintf('mu    %7.3f %7.3f %7.3f %9.3f  %7.3f %7.3f %9.3f %7.3f \n',...
            GPLUStrue1.mean_mu,GPLUStrue1.median_mu,GPLUStrue1.std_mu,GPLUStrue1.min_mu,...
             GPLUS1.mean_mu,GPLUS1.median_mu,GPLUS1.std_mu,GPLUS1.min_mu)
        fprintf('sigma %7.3f %7.3f %7.3f %9.3f  %7.3f %7.3f %9.3f %7.3f \n',...
            GPLUStrue1.mean_sigma,GPLUStrue1.median_sigma,GPLUStrue1.std_sigma,GPLUStrue1.min_sigma,...
             GPLUS1.mean_sigma,GPLUS1.median_sigma,GPLUS1.std_sigma,GPLUS1.min_sigma)
        disp('----distribution G2 -------------------------------------------------------')
        fprintf('mu    %7.3f %7.3f %7.3f %9.3f  %7.3f %7.3f %9.3f %7.3f \n',...
            GPLUStrue2.mean_mu,GPLUStrue2.median_mu,GPLUStrue2.std_mu,GPLUStrue2.min_mu,...
             GPLUS2.mean_mu,GPLUS2.median_mu,GPLUS2.std_mu,GPLUS2.min_mu)
        fprintf('sigma %7.3f %7.3f %7.3f %9.3f  %7.3f %7.3f %9.3f %7.3f \n',...
            GPLUStrue2.mean_sigma,GPLUStrue2.median_sigma,GPLUStrue2.std_sigma,GPLUStrue2.min_sigma,...
             GPLUS2.mean_sigma,GPLUS2.median_sigma,GPLUS2.std_sigma,GPLUS2.min_sigma)
            disp('----distribution G3 -------------------------------------------------------')
        fprintf('mu    %7.3f %7.3f %7.3f %9.3f  %7.3f %7.3f %9.3f %7.3f \n',...
            GPLUStrue3.mean_mu,GPLUStrue3.median_mu,GPLUStrue3.std_mu,GPLUStrue3.min_mu,...
             GPLUS3.mean_mu,GPLUS3.median_mu,GPLUS3.std_mu,GPLUS3.min_mu)
        fprintf('sigma %7.3f %7.3f %7.3f %9.3f  %7.3f %7.3f %9.3f %7.3f \n',...
            GPLUStrue3.mean_sigma,GPLUStrue3.median_sigma,GPLUStrue3.std_sigma,GPLUStrue3.min_sigma,...
             GPLUS3.mean_sigma,GPLUS3.median_sigma,GPLUS3.std_sigma,GPLUS3.min_sigma)
        disp('--------------------------------------------------------------------------')

        out = 1;

   
        if output_files_write ==1
            Gestnames =  {'GPLUSdecomp1', 'GPLUSdecomp2','GPLUSdecomp3'};
            Gtruenames = {'GPLUStruedecomp1', 'GPLUStruedecomp2','GPLUStruedecomp3'};

            for kk = 1:3
                Gtrue = eval(cell2mat(Gtruenames(kk)));
                Gest  = eval(cell2mat(Gestnames(kk)));

                duration = Gtrue.tgrid;
                HR_true    = round(Gtrue.HR_agg,5);
                STRUC_true = round(Gtrue.HR_struc_multi,5);
                HETER_true = round(Gtrue.HR_heter_multi,5);
                
                HR_est    = round(Gest.HR_agg,5);
                STRUC_est = round(Gest.HR_struc_multi,5);
                HETER_est = round(Gest.HR_heter_multi,5);
                
                tab = table(duration,HR_true,STRUC_true,HETER_true,...
                    HR_est,STRUC_est,HETER_est);
                filename = sprintf('numerical_accuracy_decomposition_%dtypes_RP.txt',kk);
                writetable(tab,filename,'Delimiter',' ');
            end
        end


return


